# FileBrowser PRO 2024.1.0

## Description
A wrapper for native file dialogs on Windows, macOS, Linux and UWP.

* Works with Windows, macOS, Linux and UWP in editor and runtime
* Full IL2CPP-support
* Open file/folder, save file dialogs supported
* Multiple file selection
* Multiple folder selection on macOS and Linux
* File extension filters
* Other platforms are currently not supported

You can download it here: [Unity AssetStore](https://assetstore.unity.com/lists/crosstales-42213?aid=1011lNGT)



## Note for MacOS-users
Your security setup must allow apps from everywhere.
If the app still doesn’t start, open Terminal and enter these commands:

cd path/to/application

chmod +x "File Browser PRO 2024.app/Contents/MacOS/File Browser PRO 2024"

### Remove from quarantine(optional): 

xattr -r -d com.apple.quarantine "File Browser PRO 2024.app/"



## Credits

Partially based on:
https://github.com/gkngkc/UnityStandaloneFileBrowser

Improvements for the Linux version:
Yinon Oshrat



## Contact

crosstales LLC
Schanzeneggstrasse 1
CH-8002 Zürich

* [Homepage](https://www.crosstales.com/)
* [Email](mailto:fb@crosstales.com)

### Social media
* [Discord](https://discord.gg/ZbZ2sh4)
* [Facebook](https://www.facebook.com/crosstales/)
* [Twitter](https://twitter.com/crosstales)
* [LinkedIN](https://www.linkedin.com/company/crosstales)



## More information
* [Homepage](https://www.crosstales.com/)
* [AssetStore](https://assetstore.unity.com/lists/crosstales-42213?aid=1011lNGT)
* [Forum](https://forum.unity.com/threads/file-browser-native-file-browser-for-windows-and-macos.510403/)
* [Documentation](https://www.crosstales.com/media/data/assets/FileBrowser/FileBrowser-doc.pdf)
* [API](https://www.crosstales.com/media/data/assets/FileBrowser/api/)

### Videos
[Youtube-channel](https://www.youtube.com/c/Crosstales)

### Demos
* [Windows-Demo](https://drive.google.com/file/d/1sE-6uhp2nk_5B85jvoiMWdk__HqUPSek/view?usp=sharing)
* [macOS-Demo](https://drive.google.com/file/d/1sAB953F-fpRmTSks9f2ZM0sMV7CEyyUA/view?usp=sharing)
* [Linux-Demo](https://drive.google.com/file/d/1LAm9v8Mu9jvF_8ZU0X3UU8nLKCdobzrj/view?usp=sharing)

### Supported 3rd party assets
* [PlayMaker](https://assetstore.unity.com/packages/slug/368?aid=1011lNGT)
* [Runtime File Browser](https://assetstore.unity.com/packages/slug/113006?aid=1011lNGT)


`Version: 08.02.2024`