# RTVoice 2024.1.0

## Description
Did you ever want to make a game for people with visual impairments or reading difficulties? 
Or want your players to not have to read too much?
Or would you listen to just the dialogues in your game without consulting a voice-actor in early stages of development?

Then RT-Voice is your time-saving solution to do so!

RT-Voice uses TTS-voices already integrated in your system to pronounce any written text at runtime.
All of this happens without intermediate steps: the transformation effects instantaneously - and, if needed, simultaneously!

You can buy it here: [AssetStore](https://assetstore.unity.com/lists/crosstales-42213?aid=1011lNGT)



## Notes

### macOS-users
Your security setup must allow apps from everywhere.
If the app still doesn't start, open Terminal and enter these commands:

cd path/to/application

chmod +x "RT-Voice PRO 2024.app/Contents/MacOS/RT-Voice PRO 2024"

#### Remove from quarantine(optional): 

xattr -r -d com.apple.quarantine "RT-Voice PRO 2024.app/"

### Linux-users
Make sure you have eSpeak installed:

sudo apt-get install espeak



## Contact

crosstales LLC
Schanzeneggstrasse 1
CH-8002 Zürich

* [Homepage](https://www.crosstales.com/en/portfolio/rtvoice/)
* [Email](mailto:rtvoice@crosstales.com)

### Social media
* [Discord](https://discord.gg/ZbZ2sh4)
* [Facebook](https://www.facebook.com/crosstales/)
* [Twitter](https://twitter.com/crosstales)
* [LinkedIN](https://www.linkedin.com/company/crosstales)



## More information
* [AssetStore](https://assetstore.unity.com/lists/crosstales-42213?aid=1011lNGT)
* [Forum](http://forum.unity3d.com/threads/rt-voice-run-time-text-to-speech-solution.340046/)
* [Documentation](https://www.crosstales.com/media/data/assets/rtvoice/RTVoice-doc.pdf)
* [API](http://www.crosstales.com/en/assets/rtvoice/api/)

### Videos
[Youtube-channel](https://www.youtube.com/c/Crosstales)

* [Promotion](https://youtu.be/iVhTWDLY7g8?list=PLgtonIOr6Tb41XTMeeZ836tjHlKgOO84S)
* [Tutorial](https://youtu.be/OJyVgCmX3wU?list=PLgtonIOr6Tb41XTMeeZ836tjHlKgOO84S)

### Demos
* [WebGL-Demo](https://www.crosstales.com/media/data/assets/rtvoice/webgl/)
* [Windows-Demo](https://drive.google.com/file/d/11BFDLbj9vmyrfltXeS_d9zK3oM9h8TaS/view?usp=sharing)
* [Mac-Demo](https://drive.google.com/file/d/11A7u7g7Cs63Bu7lv7ER9KFTVCU9oWAaT/view?usp=sharing)
* [Linux-Demo](https://drive.google.com/file/d/1XViADtStr8NXKHPMejXQ6iY4C2U_Bh3o/view?usp=sharing)
* [Android-Demo](https://drive.google.com/file/d/11FUbfuvSAAT5JgdolUKZO1sCPkTAFYJG/view?usp=sharing)


`Version: 09.02.2024`